unit NloginID;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DsgnIntf;

type
  TNloginID = class(TComponent)
  private
    FAbout: string;
    FID: string;
    FFull: string;
    function GetId: string;
    function GetFull: string;
  public
    constructor Create(AOwner:TComponent); override;
    destructor Destroy; override;
    procedure ShowAbout;
  published
    property About: string read FAbout write FAbout stored False;
    property ID: string read GetId write FID;
    property FullName: string read GetFull write FFull;
  end;

procedure Register;

type
  PhysicalNodeAddress = array[1..6] of Byte;
  PhysicalNetAddress  = array[1..4] of Byte;
  SocketNumber        = word;
  IPXAddress       = record
                       Network        : PhysicalNetAddress;
                       Node           : PhysicalNodeAddress;
                       Socket         : SocketNumber;
                     end;
  NWCCODE           = word;
  NWFLAGS           = byte;
  NWCONN_FLAGS      = word;
  NWCONN_NUM        = word;
  NWCONN_HANDLE     = word;
  NWSESSION_ID      = word;
  NWSERVER_ADDR     = IPXAddress;
  NWOBJ_ID          = longint;
  NWOBJ_TYPE        = word;
  NWSTRUCT_SIZE     = word;
  NWLOCAL_MODE      = word;
  NWSEGMENT_NUM     = byte;
  CONNECT_INFO = record
    conn        : NWCONN_HANDLE;
    connectFlags: NWCONN_FLAGS;
    sessionID   : NWSESSION_ID;
    connNumber  : NWCONN_NUM;
    serverAddr  : NWSERVER_ADDR;
    serverType  : NWOBJ_TYPE;
    serverName  : array[0..47] of char;
    clientType  : NWOBJ_TYPE;
    clientName  : array[0..47] of char;
  end;


function NWCallsInit(_in,_out: pointer): NWCCODE;
function NWGetPrimaryConnectionID
         (var conn: NWCONN_HANDLE): NWCCODE;
function NWGetConnectionStatus
          (conn: NWCONN_HANDLE;
           var connInfo: CONNECT_INFO;
           conninfoSize: NWSTRUCT_SIZE): NWCCODE;
function NWGetConnectionHandle
          (serverName: pChar;
           reserved1: NWLOCAL_MODE;
           var conn: NWCONN_HANDLE;
           reserved2: pointer): NWCCODE;
function NWReadPropertyValue
          (conn: NWCONN_HANDLE;
           objectName: pChar;
           objectType: NWOBJ_TYPE;
           propertyName: pChar;
           dataSetIndex: NWSEGMENT_NUM;
           dataBuffer: pointer{NWSEGMENT_DATA};
           var moreFlag: NWFLAGS;
           var propertyFlags: NWFLAGS): NWCCODE;


implementation

function NWCallsInit;                  external 'NWCALLS';
function NWGetPrimaryConnectionId;     external 'NWCALLS';
function NWGetConnectionStatus;        external 'NWCALLS';
function NWGetConnectionHandle;        external 'NWCALLS';
function NWReadPropertyValue;          external 'NWCALLS';


type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

procedure TAboutProperty.Edit;
{call the 'About' dialog window when clicking on ...
 in the Object Inspector}
begin
  TNloginID(GetComponent(0)).ShowAbout;
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes:=[paDialog,paReadOnly];
end;

function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue:='(About)';
end;

procedure TNloginID.ShowAbout;
var
  msg: string;
const
  carriage_return = chr(13);
  copyright_symbol = chr(169);
begin
  msg:='NloginID  v1.1';
  AppendStr(msg,carriage_return);
  AppendStr(msg,'A LunchTime Development');
  AppendStr(msg,carriage_return);
  AppendStr(msg,'(16 bit version)');
  AppendStr(msg,carriage_return);
  AppendStr(msg,carriage_return);
  AppendStr(msg,'Copyright ');
  AppendStr(msg,copyright_symbol);
  AppendStr(msg,'1996 by Danny Smalle');
  AppendStr(msg,carriage_return);
  AppendStr(msg,'e-mail 100277.3710@compuserve.com');
  AppendStr(msg,carriage_return);
  ShowMessage(msg);
end;

procedure Register;
begin
  RegisterComponents('Network',[TNloginID]);
  RegisterPropertyEditor(TypeInfo(String),TNloginID,'About',TAboutProperty);
end;

constructor TNloginID.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
end;

destructor TNloginID.Destroy;
begin
  inherited Destroy;
end;

function TNloginID.GetId: string;
var
  primary: NWCONN_HANDLE;
  sInfo: CONNECT_INFO;
  cInfo: CONNECT_INFO;
  Me: NWCONN_HANDLE;
begin
  NWGetPrimaryConnectionID(primary);
  NWGetConnectionStatus(primary,sinfo,sizeof(sinfo));
  NWGetConnectionHandle(pchar(@sinfo.serverName[0]),0,me,nil);
  NWGetConnectionStatus(me,cinfo,sizeof(cinfo));
  Result:=strpas(cinfo.clientname);
end;

function TNloginID.GetFull: string;
const
  OT_USER: word = $0100;
var
  primary: NWCONN_HANDLE;
  sInfo: CONNECT_INFO;
  primaryName: array[0..48] of char;
  Me: NWCONN_HANDLE;
  cInfo: CONNECT_INFO;
  moreFlag: NWFLAGS;
  propertyFlags: NWFLAGS;
  s: pchar;
begin
  getmem(s,256);
  NWGetPrimaryConnectionID(primary);
  NWGetConnectionStatus(primary,sinfo,sizeof(sinfo));
  NWGetConnectionHandle(pchar(@sinfo.serverName[0]),0,me,nil);
  NWGetConnectionStatus(me,cinfo,sizeof(cinfo));
  NWReadPropertyValue(primary,pchar(@cinfo.clientname),OT_USER,
                      'IDENTIFICATION',1,s,moreFlag,propertyFlags);
  result:=strpas(s);
  freemem(s,256);
end;

initialization

NWCallsInit(nil,nil);

end.
